<?php

namespace Erlage\Photogram\Constants;

class ServerConstants
{
    // literals, must be in block letters

    const SERVER_CONST_POST = 'POST';

    const SERVER_CONST_USER = 'USER';

    const SERVER_CONST_COLLECTION = 'COLLECTION';

    // loading types

    const SERVER_CONST_LOAD_TYPE_LATEST = 'type_latest';

    const SERVER_CONST_LOAD_TYPE_BOTTOM = 'type_bottom';

    // feed types

    const SERVER_CONST_FEED_TYPE_GLOBAL = 'feed_type_global';

    const SERVER_CONST_FEED_TYPE_SINGLE = 'feed_type_single';

    const SERVER_CONST_FEED_TYPE_FOLLOWINGS = 'type_followings';

    const SERVER_CONST_FEED_TYPE_FOLLOWERS = 'type_followers';

    /**
     * [server only settings] clients are not aware of these settings
     * 
     * settings having prefix ss implies server settings and these are not sent
     * to client no matter what 
     */

    /*
    |--------------------------------------------------------------------------
    | identity
    |--------------------------------------------------------------------------
    */

    const SS_TEXT_NAME = 'ss_text_name';

    const SS_TEXT_MINIMUM_API_VERSION = 'ss_text_minimum_api_version';

    const SS_TEXT_API_UPDATE_MESSAGE = 'ss_text_api_update_message';

    const SS_TEXT_API_IOS_UPDATE_URL = 'ss_text_api_ios_update_url';

    const SS_TEXT_API_ANDROID_UPDATE_URL = 'ss_text_api_android_update_url';

    /*
    |--------------------------------------------------------------------------
    | upload related
    |--------------------------------------------------------------------------
    */

    const SS_TEXT_PATH_UPLOADS = 'ss_text_path_uploads';

    /*
    |--------------------------------------------------------------------------
    | security related
    |--------------------------------------------------------------------------
    */

    const SS_INT_OTP_LIFETIME_IN_HOURS = 'ss_int_otp_lifetime_in_hours';

    const SS_INT_OTP_LIFETIME_IN_TRIES = 'ss_int_otp_lifetime_in_tries';

    const SS_BOOL_USER_EMAIL_VERIFICATION = 'ss_bool_user_email_verification';

    /*
    |--------------------------------------------------------------------------
    | mailer related
    |--------------------------------------------------------------------------
    */

    const SS_TEXT_MAILER_CONTACT_EMAIL = 'ss_text_mailer_contact_email';

    const SS_TEXT_MAILER_NO_REPLY_EMAIL = 'ss_text_mailer_no_reply_email';

    const SS_BOOL_MAILER_SMTP = 'ss_bool_mailer_smtp';

    const SS_TEXT_MAILER_SMTP_HOST = 'ss_text_mailer_smtp_host';

    const SS_INT_MAILER_SMTP_PORT = 'ss_int_mailer_smtp_port';

    const SS_TEXT_MAILER_SMTP_USERNAME = 'ss_text_mailer_smtp_username';

    const SS_TEXT_MAILER_SMTP_PASSWORD = 'ss_text_mailer_smtp_password';

    /*
    |--------------------------------------------------------------------------
    | email template related
    |--------------------------------------------------------------------------
    */

    const SS_TEXT_EMAIL_HEADER = 'ss_text_email_header';

    const SS_TEXT_EMAIL_FOOTER = 'ss_text_email_footer';

    /*
    |--------------------------------------------------------------------------
    | place holder files must exists in placeholder dir
    |--------------------------------------------------------------------------
    */

    const SS_TEXT_FILE_NAME_PLACEHOLDER_USER = 'ss_text_file_name_placeholder_user';

    const SS_TEXT_FILE_NAME_PLACEHOLDER_POST = 'ss_text_file_name_placeholder_post';

    const SS_TEXT_FILE_NAME_PLACEHOLDER_COLLECTION = 'ss_text_file_name_placeholder_collection';

    /*
    |--------------------------------------------------------------------------
    | user feeds tweaking/targetting
    |--------------------------------------------------------------------------
    */

    const SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_LIKE = 'ss_bool_implicit_hashtag_follow_on_post_like';

    const SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_COMMENT = 'ss_bool_implicit_hashtag_follow_on_post_comment';

    const SS_BOOL_IMPLICIT_HASHTAG_FOLLOW_ON_POST_COMMENT_REPLY = 'ss_bool_implicit_hashtag_follow_on_post_comment_reply';

    /*
    |--------------------------------------------------------------------------
    | content load limits
    |--------------------------------------------------------------------------
    */

    const SS_INT_LIMIT_LOAD_COLLECTION = 'ss_int_limit_load_collection';

    const SS_INT_LIMIT_LOAD_USER_FOLLOW = 'ss_int_limit_load_user_follow';

    const SS_INT_LIMIT_LOAD_USER_FOLLOW_PENDING = 'ss_int_limit_load_user_follow_pending';

    const SS_INT_LIMIT_LOAD_USER_BLOCK = 'ss_int_limit_load_user_block';

    const SS_INT_LIMIT_LOAD_HASHTAG_POST = 'ss_int_limit_load_hashtag_post';

    const SS_INT_LIMIT_LOAD_HASHTAG_POST_EXPLORE = 'ss_int_limit_load_hashtag_post_explore';

    const SS_INT_LIMIT_LOAD_POST_COMMENT_LIKE = 'ss_int_limit_load_post_comment_like';

    const SS_INT_LIMIT_LOAD_POST_COMMENT = 'ss_int_limit_load_post_comment';

    const SS_INT_LIMIT_LOAD_POST_LIKE = 'ss_int_limit_load_post_like';

    const SS_INT_LIMIT_LOAD_POST_SAVE = 'ss_int_limit_load_post_save';

    const SS_INT_LIMIT_LOAD_POST_USER_TAG = 'ss_int_limit_load_post_user_tag';

    const SS_INT_LIMIT_LOAD_POST_NEWS_FEEDS = 'ss_int_limit_load_post_news_feeds';

    const SS_INT_LIMIT_LOAD_POST_PROFILE = 'ss_int_limit_load_post_profile';

    const SS_INT_LIMIT_LOAD_USER_SEARCH = 'ss_int_limit_load_user_search';

    const SS_INT_LIMIT_LOAD_NOTIFICATION = 'ss_int_limit_load_notification';

    const SS_INT_LIMIT_LOAD_POST_INFINITE = 'ss_int_limit_load_post_infinite';

    /*
    |--------------------------------------------------------------------------
    | account settings
    |--------------------------------------------------------------------------
    */

    const SS_ENUM_USER_DEFAULT_ACCOUNT_PRIVACY = 'ss_enum_user_default_account_privacy';

    /*
    |--------------------------------------------------------------------------
    | notification settings
    |--------------------------------------------------------------------------
    */

    const SS_ENUM_NOTIFICATION_PAUSE_ALL = 'ss_enum_notification_pause_all';

    // likes on posts of user

    const SS_ENUM_NOTIFICATION_LIKES = 'ss_enum_notification_likes';

    // comments on posts of user

    const SS_ENUM_NOTIFICATION_COMMENTS = 'ss_enum_notification_comments';

    // someone tagged you in their photo

    const SS_ENUM_NOTIFICATION_PHOTOS_OF_YOU = 'ss_enum_notification_photos_of_you';

    // likes on posts in which user is tagged

    const SS_ENUM_NOTIFICATION_LIKES_ON_PHOTOS_OF_YOU = 'ss_enum_notification_likes_on_photos_of_you';

    // comments on posts in which user is tagged

    const SS_ENUM_NOTIFICATION_COMMENTS_ON_PHOTOS_OF_YOU = 'ss_enum_notification_comments_on_photos_of_you';

    // likes on comments by user

    const SS_ENUM_NOTIFICATION_COMMENT_LIKES_AND_PINS = 'ss_enum_notification_comment_likes_and_pins';

    // notify when someone accepted your follow request

    const SS_ENUM_NOTIFICATION_ACCEPTED_FOLLOW_REQUEST = 'ss_enum_notification_accepted_follow_request';

    /*
    |--------------------------------------------------------------------------
    | image compression
    |--------------------------------------------------------------------------
    */

    const SS_INT_COMPRESS_USER_DISPLAY_IMAGE_FILE_RES = 'ss_int_compress_user_display_image_file_res';

    const SS_INT_COMPRESS_POST_DISPLAY_IMAGE_FILE_RES = 'ss_int_compress_post_display_image_file_res';

    const SS_INT_COMPRESS_COLLECTION_COVER_IMAGE_FILE_RES = 'ss_int_compress_collection_cover_image_file_res';

    const SS_INT_COMPRESS_USER_DISPLAY_IMAGE_FILE_QUALITY = 'ss_int_compress_user_display_image_file_quality';

    const SS_INT_COMPRESS_POST_DISPLAY_IMAGE_FILE_QUALITY = 'ss_int_compress_post_display_image_file_quality';

    const SS_INT_COMPRESS_COLLECTION_COVER_IMAGE_FILE_QUALITY = 'ss_int_compress_collection_cover_image_file_quality';

    /*
    |--------------------------------------------------------------------------
    | storage
    |--------------------------------------------------------------------------
    */

    // active storage

    const SS_ENUM_STORAGE_DISK_USER_IMAGES = 'ss_enum_storage_disk_user_images';

    const SS_ENUM_STORAGE_DISK_POST_IMAGES = 'ss_enum_storage_disk_post_images';

    const SS_ENUM_STORAGE_DISK_COLLECTION_IMAGES = 'ss_enum_storage_disk_collection_images';

    // aws s3

    const SS_TEXT_AWS_S3_KEY = 'ss_text_aws_s3_key';

    const SS_TEXT_AWS_S3_SECRET = 'ss_text_aws_s3_secret';

    const SS_TEXT_AWS_S3_BUCKET = 'ss_text_aws_s3_bucket';

    const SS_TEXT_AWS_S3_REGION = 'ss_text_aws_s3_region';

    // azure blob

    const SS_TEXT_AZURE_BLOB_DSN = 'ss_text_azure_blob_dsn';

    const SS_TEXT_AZURE_BLOB_CONTAINER = 'ss_text_azure_blob_container';


    // wasabi s3

    const SS_TEXT_WASABI_S3_KEY = 'ss_text_wasabi_s3_key';

    const SS_TEXT_WASABI_S3_SECRET = 'ss_text_wasabi_s3_secret';

    const SS_TEXT_WASABI_S3_BUCKET = 'ss_text_wasabi_s3_bucket';

    const SS_TEXT_WASABI_S3_REGION = 'ss_text_wasabi_s3_region';
}
